local assets=
{
	Asset("ANIM", "anim/crystal.zip"),
	Asset("IMAGE", "images/inventoryimages/crystal.tex"),
	Asset("ATLAS", "images/inventoryimages/crystal.xml"),
}


local function onequip(inst, owner) 
	owner.AnimState:OverrideSymbol("swap_body", "crystal", "swap_body")
	owner.components.health.fire_damage_scale = owner.components.health.fire_damage_scale - .5
	
end

local function onunequip(inst, owner) 
    owner.AnimState:ClearOverrideSymbol("swap_body")
	owner.components.health.fire_damage_scale = owner.components.health.fire_damage_scale + .5
	
end


local function fnab()
	local inst = CreateEntity()
    
	inst.entity:AddTransform()
	inst.entity:AddAnimState()
    MakeInventoryPhysics(inst)
    	
    inst.AnimState:SetBank("crystal")
    inst.AnimState:SetBuild("crystal")
    inst.AnimState:PlayAnimation("idle", false)
    	
    inst:AddComponent("inspectable")
	
	inst:AddTag("backpack")
    	
	-- inst:AddComponent("stackable")
	-- inst.components.stackable.maxsize = 1
		
    inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.foleysound = "dontstarve/movement/foley/marblearmour"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/crystal.xml"
 
	inst:AddComponent("equippable")
    inst.components.equippable.equipslot = EQUIPSLOTS.BACK or EQUIPSLOTS.BODY
	inst.components.equippable:SetOnEquip( onequip )
    inst.components.equippable:SetOnUnequip( onunequip )
	
	inst:AddComponent("tradable")
    inst.components.tradable.goldvalue = 9
	
	inst:AddComponent("insulator")
	inst.components.insulator:SetInsulation(TUNING.INSULATION_MED)
    inst.components.insulator:SetSummer()
		
	if IsDLCEnabled(0002) then
	MakeInventoryFloatable(inst, "anim", "anim")
	end
		
    return inst
end

return Prefab( "common/inventory/crystal", fnab, assets) 